function autocorrelation(yt)
%Custom-built function that creates the autocorelation plot for a given
%signal. A lag of 20 is the maximum lag considered.
%
%Inputs:
%   yt: signal for which the autocorrelation plot is desired.
%
%Copyright 2014: Yuri Shardt
%Distributed as part of the book Statistics for Chemical and Process
%Engineers: A Modern Approach, published by Springer Verlag.

%Checking the data
q=size(yt);
N=length(yt);
lag=20;
if (N<lag)
    error('Please make sure that the size of yt is at least 20 samples.');
end
if (N==q(1) && q(2)~=1) || (N==q(2) && q(1)~=1)
    error('Please make sure that yt is either a row or column vector.');
end
y=detrend(yt,0);

%Obtain the autocorrelation values
q=xcorr(y,y);
count=N;

%Creating the plot
plot([0:lag],q(count:count+lag)/max(q),'ok')
grid on
hold on;plot([0,lag],tinv(0.975,N)*[1,1]/sqrt(N),'--k','linewidth',2)
plot([0,lag],-tinv(0.975,N)*[1,1]/sqrt(N),'--k','linewidth',2)
plot([0,lag],[0,0],'-k')
xlabel(['Lag (samples)'],'interpreter','latex'),ylabel('Autocorrelation, $\rho$','interpreter','latex')

end